/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2000 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/

#ifndef __PIUSuites_H__		// Has this not been defined yet?
#define __PIUSuites_H__		// Only include this once by predefining it

#include "PITypes.h"
#include "PIGeneral.h"
#include "SPBasic.h"
#include <string.h>

extern SPBasicSuite* sSPBasic;

// A simple template for acquiring and release suites.
// Depends on a globally defined sSPBasic pointer.
// Illustrator example
// MySuite<AITextPathSuite> sAITextPath(kAITextPathSuite, kAITextPathSuiteVersion);
// if (sAITextPath.IsNull()) goto returnError;
template<class T> class MySuite
{
private:
	T* mySuite;
	long mySuiteVersion;
	char* mySuiteName;
	SPErr error;
	T& operator*(){ return *mySuite; }

	// make sure the compiler doesn't create this
	MySuite();
public:
	MySuite(char* suiteName, long suiteVersion) : 
	  mySuite(NULL), mySuiteName(NULL), mySuiteVersion(suiteVersion)
	{ 
		if (sSPBasic != NULL)
		{
			mySuiteName = new char[strlen(suiteName)+1];
			if (mySuiteName == NULL)
			{
				error = kSPOutOfMemoryError;
			}
			else
			{
				strcpy(mySuiteName, suiteName);
				error = sSPBasic->AcquireSuite(mySuiteName, 
				                               mySuiteVersion, 
				 							   (void**)&mySuite);
				if (error)
				{
					mySuite = NULL;
					delete [] mySuiteName;
					mySuiteName = NULL;
				}
			}
		}
	}

	~MySuite()
	{
		if (mySuiteName != NULL && sSPBasic != NULL)
			sSPBasic->ReleaseSuite(mySuiteName, mySuiteVersion);
		delete [] mySuiteName;
	}

	T* operator->(){ return mySuite; }
	bool IsNull(){ return (mySuite == NULL); }
	SPErr GetError() { return error; }
};


typedef struct
{
	char*	name;
	int16	version;
	void**	suitePtr;
} _AcquireList;

void PIUSuitesRelease(SPBasicSuite* sSPBasic, 
				      _AcquireList* suitesToRelease, 
					  int16 numSuites);
SPErr PIUSuitesAcquire(SPBasicSuite* sSPBasic, 
					   _AcquireList* suitesToAcquire, 
					   int16 numSuites);

#endif
// end PIUSuites.h